<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NotesLog extends Model 
{

    protected $table = 'notes_log';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status', 'due_date');

    public function note()
    {
        return $this->belongsTo('App\Models\Notes');
    }

}